/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.installer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.magmafoundation.magma.MagmaStart;
import org.magmafoundation.magma.common.MagmaConstants;
import org.magmafoundation.magma.common.utils.JarTool;
import org.magmafoundation.magma.common.utils.MD5;

public abstract class AbstractMagmaInstaller {
    private PrintStream origin = System.out;
    public String forgeVer;
    public String mcpVer;
    public String mcVer;
    public String libPath = new File(JarTool.getJarDir(), "libraries").getAbsolutePath() + "/";
    public String forgeStart;
    public File universalJar;
    public File serverJar;
    public File lzma;
    public File installInfo;
    public String otherStart;
    public File extra;
    public File slim;
    public File srg;
    public String mcpStart;
    public File mcpZip;
    public File mcpTxt;
    public File minecraft_server;

    protected AbstractMagmaInstaller() {
        this.forgeVer = MagmaConstants.FORGE_VERSION_FULL.split("-")[1];
        this.mcpVer = MagmaConstants.FORGE_VERSION_FULL.split("-")[3];
        this.mcVer = MagmaConstants.FORGE_VERSION_FULL.split("-")[0];
        this.forgeStart = this.libPath + "net/minecraftforge/forge/" + this.mcVer + "-" + this.forgeVer + "/forge-" + this.mcVer + "-" + this.forgeVer;
        this.universalJar = new File(this.forgeStart + "-universal.jar");
        this.serverJar = new File(this.forgeStart + "-server.jar");
        this.lzma = new File(this.libPath + "org/magma/install/data/server.lzma");
        this.installInfo = new File(this.libPath + "org/magma/install/installInfo");
        this.otherStart = this.libPath + "net/minecraft/server/" + this.mcVer + "-" + this.mcpVer + "/server-" + this.mcVer + "-" + this.mcpVer;
        this.extra = new File(this.otherStart + "-extra.jar");
        this.slim = new File(this.otherStart + "-slim.jar");
        this.srg = new File(this.otherStart + "-srg.jar");
        this.mcpStart = this.libPath + "de/oceanlabs/mcp/mcp_config/" + this.mcVer + "-" + this.mcpVer + "/mcp_config-" + this.mcVer + "-" + this.mcpVer;
        this.mcpZip = new File(this.mcpStart + ".zip");
        this.mcpTxt = new File(this.mcpStart + "-mappings.txt");
        this.minecraft_server = new File(this.libPath + "minecraft_server." + this.mcVer + ".jar");
    }

    protected void launchService(String mainClass, List<String> args, List<URL> classPath) throws Exception {
        try {
            Class.forName(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
        }
        URLClassLoader loader = URLClassLoader.newInstance(classPath.toArray(new URL[0]));
        Class.forName(mainClass, true, loader).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args.toArray(new String[0])});
        loader.clearAssertionStatus();
        loader.close();
    }

    protected List<URL> stringToUrl(List<String> strs) throws Exception {
        ArrayList<URL> temp = new ArrayList<URL>();
        for (String t : strs) {
            temp.add(new File(t).toURI().toURL());
        }
        return temp;
    }

    protected void mute() throws Exception {
        File out = new File("logs/installer.log");
        if (!out.exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(out))));
    }

    protected void unmute() {
        System.setOut(this.origin);
    }

    protected void copyFileFromJar(File file, String pathInJar) throws Exception {
        InputStream is = MagmaStart.class.getClassLoader().getResourceAsStream(pathInJar);
        if (!file.exists() || !MD5.getMd5(file).equals(MD5.getMd5(is)) || file.length() <= 1L) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            if (is != null) {
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                System.out.println("The file " + file.getName() + " was not found in the jar.");
                System.exit(0);
            }
        }
    }

    protected void deleteIfExists(File file) throws IOException {
        Files.deleteIfExists(file.toPath());
        File dir = file.getParentFile();
        if (dir.isDirectory() && dir.list().length == 0) {
            Files.delete(dir.toPath());
        }
    }

    protected void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    protected boolean isCorrupted(File f) {
        try {
            JarFile j = new JarFile(f);
            j.close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    protected void restartServer(List<String> arguments) throws Exception {
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = new File(AbstractMagmaInstaller.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (!currentJar.getName().endsWith(".jar")) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-jar");
        command.add(currentJar.getPath());
        arguments.parallelStream().forEach(command::add);
        command.add("-postinstall");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        System.exit(0);
    }

    private void clearConsole() {
        try {
            String os = System.getProperty("os.name");
            if (os.contains("Windows")) {
                Runtime.getRuntime().exec("cls");
            } else {
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

